/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
 */
#ifndef KSAL_ZSTD_H
#define KSAL_ZSTD_H

#include <stdint.h>
#include <stddef.h>

/* compile time determination of SIMD support */
#if !defined(ZSTD_NO_INTRINSICS)
#  if defined(__SSE2__) || defined(_M_AMD64) || (defined (_M_IX86) && defined(_M_IX86_FP) && (_M_IX86_FP >= 2))
#    define ZSTD_ARCH_X86_SSE2
#  endif
#  if defined(__ARM_NEON) || defined(_M_ARM64)
#    define ZSTD_ARCH_ARM_NEON
#  endif
#
#  if defined(ZSTD_ARCH_X86_SSE2)
#    include <emmintrin.h>
#  elif defined(ZSTD_ARCH_ARM_NEON)
#    include <arm_neon.h>
#  endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

uint32_t HufDecompressReturnValue(uint32_t dtime);

void ZstdOverlapCopy82(uint8_t *op, uint8_t const **ip, size_t offset);

#ifdef __cplusplus
}
#endif

#endif